<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('doctors', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('title')->nullable();
            $table->string('first_name');
            $table->string('last_name');
            $table->string('specialization')->nullable();
            $table->string('qualification')->nullable();
            $table->string('practice_number')->unique();
            $table->string('country')->default('Lesotho');
            $table->text('educational_details')->nullable();
            $table->string('phone')->nullable();
            $table->string('email')->unique();
            $table->string('letterhead_path')->nullable();
            $table->string('stamp_path')->nullable();
            $table->string('signature_path')->nullable();
            $table->boolean('is_verified')->default(false);
            $table->boolean('is_active')->default(false);
            $table->timestamp('verified_at')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('doctors');
    }
};

